package org.msh.tb.bd.tbforms.dhis2.tb12;

import org.msh.tb.bd.tbforms.dhis2.DHIS2ExportAsyncTask;
import org.msh.tb.bd.tbforms.dhis2.data.AuthResponse;
import org.msh.tb.bd.tbforms.dhis2.data.DataValuePayload;
import org.msh.tb.bd.tbforms.dhis2.data.DataValueResponse;
import org.msh.tb.bd.tbforms.dhis2.tb12.blockbuilders.TBForm12Table1Builder;
import org.msh.tb.bd.tbforms.dhis2.tb12.blockbuilders.TBForm12Table2Builder;
import org.msh.tb.entities.Tbunit;
import org.msh.utils.date.DateUtils;

/**
 * Created by Mauricio on 20/04/2017.
 * Async task that send TB 12 Information to DHIS2
 */
public class DHIS2ExportTB12AsyncTask extends DHIS2ExportAsyncTask {

    public static final String TB12_DHIS2_DATA_SET_ID = "pgGUKl6VOBJ";

    @Override
    protected void execute() {
        try {
            // login into DHIS2
            AuthResponse credentials = dHIS2AuthenticationService.auth();
            this.setProgress(8);

            // Instantiate block builders
            TBForm12Table1Builder table1Builder = new TBForm12Table1Builder();
            TBForm12Table2Builder table2Builder = new TBForm12Table2Builder();

            for (int i = 0; i < tbunits.size(); i++) {
                Tbunit tbunit = tbunits.get(i);

                // instantiate and start to prepare payload
                DataValuePayload payload = new DataValuePayload();
                payload.setDataSet(getFormId());
                payload.setCompleteData(DateUtils.getDate());
                payload.setOrgUnit(tbunit.getDhis2Id());
                payload.setPeriod(selectedQuarter.getDHIS2QuarterCode());

                // get information about blocks in DB and mount it in payload
                table1Builder.buildBlock(tbunit, selectedQuarter, payload);
                table2Builder.buildBlock(tbunit, selectedQuarter, payload);

                // only sends request if dataValues are found.
                if (payload.getDataValues() != null) {

                    // send unit TB 11 Form information
                    DataValueResponse response = dHIS2DataExportService.sendData(credentials, payload);

                    saveTransactionLog(response, tbunit, selectedQuarter);
                }

                // update progress
                double p = 92.0/tbunits.size();
                p = (p*(i+1))+8.0;
                this.setProgress(new Double(p).intValue());
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String getFormId() {
        return TB12_DHIS2_DATA_SET_ID;
    }

    @Override
    protected String getEventName() {
        return "DHIS2_INTEGRATION_TB12";
    }

    @Override
    public boolean isLogged() {
        return true;
    }
}
